import * as common from '/pages/src/common.mjs';

const valEl = document.getElementById('draft-value');
const barEl = document.getElementById('draft-bar');
const statusEl = document.getElementById('status-text');
const dashEl = document.getElementById('dash');
const wrapperEl = document.getElementById('wrapper');

// Variables par défaut
let userOpacity = 90;
let userZoom = 100;
const MAX_SAVINGS_PCT = 40; 

// --- GESTION DES REGLAGES ---
function loadSettings() {
    const sOp = localStorage.getItem('myMod_Draft_Op');
    const sZoom = localStorage.getItem('myMod_Draft_Zoom');

    if(sOp) userOpacity = parseInt(sOp);
    if(sZoom) userZoom = parseInt(sZoom);

    // On applique aux inputs
    const opInput = document.getElementById('in-opacity');
    const zoomInput = document.getElementById('in-zoom');
    
    if(opInput) opInput.value = userOpacity;
    if(zoomInput) zoomInput.value = userZoom;

    applyVisuals();
}

function saveSettings() {
    userOpacity = parseInt(document.getElementById('in-opacity').value);
    userZoom = parseInt(document.getElementById('in-zoom').value);

    localStorage.setItem('myMod_Draft_Op', userOpacity);
    localStorage.setItem('myMod_Draft_Zoom', userZoom);

    applyVisuals();
    document.getElementById('settings-panel').style.display = 'none';
}

function applyVisuals() {
    document.getElementById('op-label').innerText = userOpacity;
    // Si opacité est 0, le fond devient totalement transparent
    dashEl.style.backgroundColor = `rgba(0, 0, 0, ${userOpacity/100})`;
    
    document.getElementById('zoom-label').innerText = (userZoom/100).toFixed(1);
    wrapperEl.style.transform = `scale(${userZoom/100})`;
}

// --- MISE A JOUR DRAFT ---
function updateDisplay(state) {
    if (!state) return;

    const playerPower = state.power || 0;
    let draftWatts = state.draft || 0;
    if (draftWatts < 0) draftWatts = 0;

    // 1. Chiffre
    valEl.innerText = Math.round(draftWatts);

    // 2. Barre
    const totalPower = playerPower + draftWatts;
    let savingsPct = 0;
    if (totalPower > 0) {
        savingsPct = (draftWatts / totalPower) * 100;
    }

    let barFill = (savingsPct / MAX_SAVINGS_PCT) * 100;
    if (barFill > 100) barFill = 100;
    barEl.style.width = barFill + '%';

    // 3. Texte et Couleurs (Texte avec ombre portée pour lisibilité)
    if (draftWatts < 5) {
        statusEl.innerText = "DANS LE VENT";
        statusEl.style.color = "#aaa"; 
        valEl.style.color = "white";
    } else if (savingsPct < 15) {
        statusEl.innerText = "ABRI LÉGER";
        statusEl.style.color = "#ffffcc"; 
        valEl.style.color = "#ffffcc";
    } else {
        statusEl.innerText = "ASPIRATION MAX";
        statusEl.style.color = "#44ff44"; 
        valEl.style.color = "#44ff44";
    }
}

// --- MAIN ---
export async function main() {
    loadSettings();

    // Boutons Réglages
    document.getElementById('btn-settings').addEventListener('click', () => {
        const p = document.getElementById('settings-panel');
        p.style.display = p.style.display === 'block' ? 'none' : 'block';
    });
    document.getElementById('btn-save').addEventListener('click', saveSettings);

    document.getElementById('in-opacity').addEventListener('input', (e) => {
        userOpacity = e.target.value; applyVisuals();
    });
    document.getElementById('in-zoom').addEventListener('input', (e) => {
        userZoom = e.target.value; applyVisuals();
    });

    // Connexion
    if (common && common.initInteractionListeners) {
        common.initInteractionListeners();
        common.subscribe('athlete/watching', (packet) => {
            if(packet && packet.state) {
                updateDisplay(packet.state);
            }
        });
    }
}