import * as common from '/pages/src/common.mjs';

let userFTP = 250;
let userWeight = 75;
let userMaxHR = 190;
let userOpacity = 90;
let userZoom = 100;

// --- REGLAGES ---
function loadSettings() {
    // FTP/Poids sont partagés entre les mods
    const sFTP = localStorage.getItem('myMod_FTP');
    const sWeight = localStorage.getItem('myMod_Weight');
    const sFC = localStorage.getItem('myMod_FC');
    // Opacité/Zoom sont propres à cette fenêtre
    const sOp = localStorage.getItem('myMod_Accel_Op');
    const sZoom = localStorage.getItem('myMod_Accel_Zoom');

    if(sFTP) userFTP = parseInt(sFTP);
    if(sWeight) userWeight = parseFloat(sWeight);
    if(sFC) userMaxHR = parseInt(sFC);
    if(sOp) userOpacity = parseInt(sOp);
    if(sZoom) userZoom = parseInt(sZoom);

    // Remplir menu
    document.getElementById('in-ftp').value = userFTP;
    document.getElementById('in-weight').value = userWeight;
    document.getElementById('in-fc').value = userMaxHR;
    document.getElementById('in-opacity').value = userOpacity;
    document.getElementById('in-zoom').value = userZoom;
    
    applyVisuals();
}

function saveSettings() {
    const f = document.getElementById('in-ftp').value;
    const w = document.getElementById('in-weight').value;
    const h = document.getElementById('in-fc').value;
    const o = document.getElementById('in-opacity').value;
    const z = document.getElementById('in-zoom').value;

    if(f) { userFTP = parseInt(f); localStorage.setItem('myMod_FTP', userFTP); }
    if(w) { userWeight = parseFloat(w); localStorage.setItem('myMod_Weight', userWeight); }
    if(h) { userMaxHR = parseInt(h); localStorage.setItem('myMod_FC', userMaxHR); }
    
    userOpacity = parseInt(o); localStorage.setItem('myMod_Accel_Op', userOpacity);
    userZoom = parseInt(z); localStorage.setItem('myMod_Accel_Zoom', userZoom);

    applyVisuals();
    document.getElementById('settings-panel').style.display = 'none';
}

function applyVisuals() {
    // Opacité
    document.getElementById('op-label').innerText = userOpacity;
    document.getElementById('dash').style.backgroundColor = `rgba(0, 0, 0, ${userOpacity/100})`;
    
    // Zoom
    document.getElementById('zoom-label').innerText = (userZoom/100).toFixed(1);
    document.getElementById('wrapper').style.transform = `scale(${userZoom/100})`;
}

// --- COULEURS ---
function getZonePower(val, ref) {
    if (!val || !ref) return 'z1';
    const pct = (val / ref) * 100;
    if (pct < 60) return 'z1'; if (pct < 76) return 'z2'; if (pct < 90) return 'z3';
    if (pct < 105) return 'z4'; if (pct < 119) return 'z5'; return 'z6';
}
function getZoneRPM(rpm) {
    if (rpm < 80) return 'rpm-low'; if (rpm < 100) return 'rpm-opt';
    if (rpm < 120) return 'rpm-high'; return 'rpm-very-high';
}
function getZoneGrade(gradePct) {
    if (gradePct < -5) return 'grade-vert'; if (gradePct < -1) return 'grade-bleu';
    if (gradePct <= 1) return 'grade-blanc'; if (gradePct <= 5) return 'grade-jaune';
    if (gradePct <= 9) return 'grade-orange'; if (gradePct <= 14) return 'grade-rouge-c';
    return 'grade-rouge-f';
}

// --- MISE A JOUR ---
function updateDisplay(state) {
    if (!state) return;

    const power = state.power || 0;
    const hr = state.heartrate || 0;
    const rpm = state.cadence || 0;
    const gradePct = ((state.grade || 0) * 100).toFixed(1);

    // Poids manuel ou Zwift
    const w = userWeight > 0 ? userWeight : (state.weight || 75);
    const wkg = w > 0 ? (power / w).toFixed(1) : 0.0;

    const zPower = getZonePower(power, userFTP);
    const zHR = getZonePower(hr, userMaxHR);
    const zRPM = getZoneRPM(rpm);
    const zGrade = getZoneGrade(parseFloat(gradePct));

    const elWatts = document.getElementById('val-watts');
    elWatts.innerText = power; elWatts.className = 'value ' + zPower;

    const elWkg = document.getElementById('val-wkg');
    elWkg.innerText = wkg; elWkg.className = 'value ' + zPower;

    const elHr = document.getElementById('val-hr');
    elHr.innerText = hr; elHr.className = 'value ' + zHR;

    const elRpm = document.getElementById('val-rpm');
    elRpm.innerText = rpm; elRpm.className = 'value ' + zRPM;

    const elGrade = document.getElementById('val-grade');
    elGrade.innerText = gradePct + '%'; elGrade.className = 'value ' + zGrade;

    document.getElementById('dash').style.borderColor = (zPower === 'z1') ? '#ffffff' : getComputedStyle(elWatts).color;
}

// --- MAIN ---
export async function main() {
    loadSettings();

    // Event Listeners
    document.getElementById('btn-settings').addEventListener('click', () => {
        const p = document.getElementById('settings-panel');
        p.style.display = p.style.display === 'block' ? 'none' : 'block';
    });
    document.getElementById('btn-save').addEventListener('click', saveSettings);
    // Live preview sliders
    document.getElementById('in-opacity').addEventListener('input', (e) => {
        userOpacity = e.target.value; applyVisuals();
    });
    document.getElementById('in-zoom').addEventListener('input', (e) => {
        userZoom = e.target.value; applyVisuals();
    });

    if (common && common.initInteractionListeners) {
        common.initInteractionListeners();
        common.subscribe('athlete/watching', (packet) => {
            if(packet && packet.state) updateDisplay(packet.state);
        });
    }
}